;**********************************************************************
;   Ce fichier est la base de dpart pour une programmation avec      *
;   le PIC 16F88. Il contient  les informations de  base pour         *
;   dmarrer.                                                         *  
;                                                                     *
;   Si les interruptions ne sont pas utilises, supprimez les lignes  *
;   entre ORG 0x004 et l'tiquette init. De plus, les variables       *
;   w_temp et status_temp peuvent tre supprimes.                    *
;                                                                     *
;**********************************************************************
;                                                                     *
;    NOM:                                                             *
;    Date:                                                            *
;    Version:                                                         *
;    Circuit:                                                         *
;    Auteur:                                                          *
;                                                                     *
;**********************************************************************
;                                                                     *
;    Fichier requis: P16F88.inc                                       *
;                                                                     *
;                                                                     *
;                                                                     *
;**********************************************************************
;                                                                     *
;    Notes:   code pour faire  fonctionn l'usart en reception        *
;    9200BAUDS 1BIT START 1BIT STOP sans pariter                      *
;    horloge  8MHZ 1cycle 0,5 microseconde  interne                   *
;                                                                     *
;                                                                     *
;                                                                     *
;                                                                     *
;**********************************************************************

    ERRORLEVEL -302			; suppression du message bank select 
	LIST      P=PIC16F88            ; Dfinition de processeur
	#include <p16F88.inc>           ; fichier include


	__CONFIG  	_CONFIG1, _CP_OFF & _CCP1_RB3 & _DEBUG_OFF & _WRT_PROTECT_OFF & _CPD_OFF & _LVP_OFF & _BODEN_OFF & _MCLR_ON & _PWRTE_ON & _WDT_OFF & _INTRC_IO
 __CONFIG _CONFIG2, _IESO_OFF & _FCMEN_OFF
; '__CONFIG' prcise les paramtres encods dans le processeur au moment de
; la programmation. Les dfinitions sont dans le fichier include.
; Voici les valeurs et leurs dfinitions :
;	_CP_ON				Code protection ON : impossible de relire
;	_CP_OFF				Code protection OFF
;	_PWRTE_ON			Timer reset sur power on en service
;	_PWRTE_OFF			Timer reset hors-service
;	_WDT_ON				Watch-dog en service
;	_WDT_OFF			Watch-dog hors service
;	_LP_OSC				Oscillateur quartz basse vitesse
;	_XT_OSC				Oscillateur quartz moyenne vitesse
;	_HS_OSC				Oscillateur quartz grande vitesse
;	_RC_OSC				Oscillateur  rseau RC

;*********************************************************************
;                              ASSIGNATIONS                          *
;*********************************************************************
BRGVAL      EQU B'10000001'    ; 129 debit 9615
OSCCONVAL   EQU B'01100010'    ; 8MHZ
OPTIONVAL	EQU	B'10000111'	   ; horloge interne prdiviseur 256 sur TMRO 
INTCONVAL   EQU B'11000000'    ; interuption prphriques                     
PIE1VAL     EQU B'00100000'    ;   

PIE2VAL     EQU B'00000000'

CVRCONVAL   EQU B'00000000'

ANSELVAL    EQU B'00000000'    ;digital 


CMCONVAL    EQU B'00000111'    ;


DIRPORTA    EQU B'00010000'    ; tout les ports configurer en sortie sauf PORTA4
              
DIRPORTB    EQU B'00100100'    ;bit 2 et 5 en entrer pour la reception USART  

;*********************************************************************
;                             DEFINE                                 *
;*********************************************************************

; exemples
; ---------


;*********************************************************************
;                             MACRO                                  *
;*********************************************************************

BANK0	macro				; passer en banque0
		bcf	STATUS,RP0
		bcf	STATUS,RP1
	ENDM

BANK1	macro				; passer en banque1
		bsf	STATUS,RP0
		bcf	STATUS,RP1
	ENDM

BANK2	macro				; passer en banque2
		bcf	STATUS,RP0
		bsf	STATUS,RP1
	ENDM

BANK3	macro				; passer en banque3
		bsf	STATUS,RP0
		bsf	STATUS,RP1
    ENDM





;*********************************************************************
;                   VARIABLES ZONE COMMUNE                           *
;*********************************************************************



	CBLOCK 0x70			; Dbut de la zone (0x70  0x7F)
	w_temp : 1			; Sauvegarde registre W  B'0111 0000'
	status_temp : 1		; sauvegarde registre STATUS  B'0111 0001'
	FSR_temp : 1	    ; sauvegarde FSR (si indirect en interrupt) B'0111 0010'
	PCLATH_temp : 1		; sauvegarde PCLATH (si prog>2K) B'0111 0011'
	cmpt1 : 1			; compteur de boucles 1 B'0111 0100'
	cmpt2 : 1			; compteur de boucles 2  B'0111 0101'
    cmpt3 : 1           ; compteur de boucles 3 B'0111 0111' 
	valeur_comparer:1   ; variable avec adress dela lettre a  B'0111 1000' 
    pointer:1           ; buffer qui recuper l'octet  B'0111 1001'
    bufin:1             ;  B'0111 1010'
    finbufin:1          ;  B'0111 1011'
    n:1                 ; varaible pour contenir la valeur de la lettre a que contient la variable valeur_comparer
    ENDC                      

;*********************************************************************
;                   VARIABLES BANK 0                          *
;*********************************************************************
    

;**********************************************************************
;                      DEMARRAGE SUR RESET                            *
;**********************************************************************

	org 0x000 					; Adresse de dpart aprs reset

    goto init                     
;**********************************************************************
;                     ROUTINE INTERRUPTION                            *
;**********************************************************************

		;*****************************************************************************
;                     ROUTINE INTERRUPTION                                   *
;*****************************************************************************
;-----------------------------------------------------------------------------
; Si on n'utilise pas l'adressage indirect dans les interrupts, on se passera
; de sauvegarder FSR ainsi que la restauration dans restorereg
; Si le programme ne fait pas plus de 2K, on se passera de la gestion de 
; PCLATH ainsi que la restauration dans restorereg
;-----------------------------------------------------------------------------
			;sauvegarder registres	
			;---------------------
	org 0x004			    ; adresse d'interruption
	movwf   w_temp  		; sauver registre W
	swapf	STATUS,w		; swap status avec rsultat dans w
	movwf	status_temp		; sauver status swapp
	movf	FSR , w			; charger FSR
	movwf	FSR_temp		; sauvegarder FSR
	movf	PCLATH , w		; charger PCLATH
	movwf	PCLATH_temp		; le sauver
	BANK0			     	; passer en banque0

			; switch vers diffrentes interrupts
	
			; mais attention alors au test PEIE
			; effacer les inutiles
			;----------------------------------------
	
			; Interruption TMR0
			; -----------------

	btfsc	INTCON,TMR0IE		; tester si interrupt timer autorise
	btfss	INTCON,TMR0IF		; oui, tester si interrupt timer en cours
	goto 	intsw1			; non test suivant
	call	inttmr0			; oui, traiter interrupt tmr0
	bcf	    INTCON,TMR0IF		; effacer flag interrupt tmr0
	goto	restorereg		; et fin d'interruption
				; SUPPRIMER CETTE LIGNE POUR
				; TRAITER PLUSIEURS INTERRUPT
				; EN 1 SEULE FOIS

			; Interruption RB0/INT
			; --------------------
intsw1
	btfsc	INTCON,INTE		; tester si interrupt RB0 autorise
	btfss	INTCON,INTF		; oui, tester si interrupt RB0 en cours
	goto 	intsw2			; non sauter au test suivant
	call	intrb0			; oui, traiter interrupt RB0
	bcf	    INTCON,INTF		; effacer flag interupt RB0
	goto	restorereg		; et fin d'interruption
				; SUPPRIMER CETTE LIGNE POUR
				; TRAITER PLUSIEURS INTERRUPT
				; EN 1 SEULE FOIS

			; interruption RB4/RB7
			; --------------------
intsw2
	btfsc	INTCON,RBIE		; tester si interrupt RB4/7 autorise
	btfss	INTCON,RBIF		; oui, tester si interrupt RB4/7 en cours
	goto 	intsw3			; non sauter
	call	intrb4			; oui, traiter interrupt RB4/7
	bcf  	INTCON,RBIF		; effacer flag interupt RB4/7
	goto	restorereg		; et fin d'interrupt

			; dtection interruptions priphriques
			; le test peut tre supprim si une seule
			; interrupt est traite  la fois
			; --------------------------------------
intsw3
	btfss	INTCON,PEIE		; tester interruption priphrique autorise
	goto	restorereg		; non, fin d'interruption

	

			; Interruption rception USART
			; ----------------------------
intsw4
	BANK1				    ; slectionner banque1
	btfss	PIE1,RCIE		; tester si interrupt autorise
	goto 	intsw5			; non sauter
	BANK0				    ; oui, slectionner banque0
	btfss	PIR1,RCIF		; oui, tester si interrupt en cours
	goto 	intsw5			; non sauter
	call	intrc			; oui, traiter interrupt
 			

			; Interruption transmission USART
			; -------------------------------
intsw5
	BANK1				; slectionner banque1
	btfss	PIE1,TXIE		; tester si interrupt autorise
	goto 	intsw6			; non sauter
	BANK0				; oui, slectionner banque0
	btfss	PIR1,TXIF		; oui, tester si interrupt en cours
	goto 	intsw6			; non sauter
	call	inttx			; oui, traiter interrupt
				; LE FLAG NE DOIT PAS ETRE REMIS A 0
				; C'EST L'ECRITURE DE TXREG QUI LE PROVOQUE
	goto	restorereg		; et fin d'interrupt

			; Interruption comparateurs
			; -------------------------
intsw6
	BANK1				; slectionner banque1
	btfss	PIE2,CMIE		; tester si interrupt autorise
	goto 	intsw7			; non sauter
	BANK0				; oui, slectionner banque0
	btfss	PIR1,CMIF		; oui, tester si interrupt en cours
	goto 	intsw7			; non sauter
	call	intcmp			; oui, traiter interrupt
	bcf	PIR1,CMIF		; effacer flag interupt comparateur
	goto	restorereg		; et fin d'interrupt
	

			; Interruption CCP1
			; -----------------
intsw7
	BANK1				; slectionner banque1
	btfss	PIE1,CCP1IE		; tester si interrupt autorise
	goto 	intsw8			; non sauter
	BANK0				; oui, slectionner banque0
	btfss	PIR1,CCP1IF		; oui, tester si interrupt en cours
	goto 	intsw8			; non sauter
	call	intccp1			; oui, traiter interrupt
	bcf	PIR1,CCP1IF		; effacer flag interupt 
	goto	restorereg		; et fin d'interrupt


			; Interruption TMR2
			; -----------------
intsw8
	BANK1				; slectionner banque1
	btfss	PIE1,TMR2IE		; tester si interrupt autorise
	goto 	intsw9			; non sauter
	BANK0				; oui, slectionner banque0
	btfss	PIR1,TMR2IF		; oui, tester si interrupt en cours
	goto 	intsw9			; non sauter
	call	inttmr2			; oui, traiter interrupt
	bcf	PIR1,TMR2IF		; effacer flag interupt 
	goto	restorereg		; et fin d'interrupt

			; Interruption TMR1
			; -----------------
intsw9
	BANK1				; slectionner banque1
	btfss	PIE1,TMR1IE		; tester si interrupt autorise
	goto 	intswA			; non sauter
	BANK0				; oui, slectionner banque0
	btfss	PIR1,TMR1IF		; oui, tester si interrupt en cours
	goto 	intswA			; non sauter
	call	inttmr1			; oui, traiter interrupt
	bcf	PIR1,TMR1IF		; effacer flag interupt 
	goto	restorereg		; et fin d'interrupt

			; Interruption EEPROM
			; -------------------
intswA
	BANK1				; slectionner banque1
	btfss	PIE2,EEIE		; tester si interrupt autorise
	goto 	intswB			; non sauter
	BANK0				; oui, slectionner banque0
	btfss	PIR2,EEIF		; oui, tester si interrupt en cours
	goto 	intswB			; non sauter
	call	inteprom		; oui, traiter interrupt
	bcf	    PIR2,EEIF		; effacer flag interupt 
	goto	restorereg		; et fin d'interrupt



			; Interruption convertisseur A/D
			; ------------------------------
intswB
	BANK1				; slectionner banque1
	btfss	PIE1,ADIE		; tester si interrupt autorise
	goto 	restorereg		; non sauter
	bcf	STATUS,RP0		; oui, slectionner banque0
	btfss	PIR1,ADIF		; tester si interrupt en cours
	goto 	restorereg		; non sauter
	call	intad			; oui, traiter interrupt
	bcf	PIR1,ADIF		; effacer flag interupt 
	goto	restorereg		; et fin d'interrupt


	
			;restaurer registres
			;-------------------
restorereg
	movf	PCLATH_temp , w		; recharger ancien PCLATH
	movwf	PCLATH			; le restaurer
	movf	FSR_temp , w		; charger FSR sauv
	movwf	FSR			; restaurer FSR
	swapf	status_temp,w		; swap ancien status, rsultat dans w
	movwf   STATUS			; restaurer status
	swapf   w_temp,f		; Inversion L et H de l'ancien W
                       			; sans modifier Z
	swapf   w_temp,w  		; Rinversion de L et H dans W
					; W restaur sans modifier status
	retfie  			; return from interrupt

;*****************************************************************************
;                        INTERRUPTION TIMER 0                                *
;*****************************************************************************
inttmr0
	return				; fin d'interruption timer
					; peut tre remplac par 
					; retlw pour retour code d'erreur

;*****************************************************************************
;                        INTERRUPTION RB0/INT                                *
;*****************************************************************************
intrb0
	return				; fin d'interruption RB0/INT
					; peut tre remplac par 
					; retlw pour retour code d'erreur

;*****************************************************************************
;                         INTERRUPTION RB4/RB7                               *
;*****************************************************************************
intrb4
	return			; fin d'interruption RB4/RB7
					; peut tre remplac par 
					; retlw pour retour code d'erreur

;*****************************************************************************
;                     INTERRUPTION RECEPTION USART                           *
;*****************************************************************************
intrc
    
    BANK0
    movf  pointer,w;charge l'adresse de la variable bufin dans w
    movwf FSR      ;puis dans fsr 
    movf  RCREG,w ;charge l'octet recu dans w
    movwf INDF    ;m'est l'octet dans INDF donc a l'interieur de la variable bufin
    btfss PIR1,RCIF 
    goto  finreception
    INCF  FSR,w   ;on increment fsr donc l'adresse de bufin 
    xorlw finbufin; on vrifie si on a atteint la limite 
    btfsc STATUS,Z; si le resultat sur z=1 on atteint la limite
    goto  finreception
    goto  intrc 	
    finreception 
    movlw  bufin 
    movwf  pointer; on replace la premier adresse de depart de bufin
    BANK1
    bcf PIE1,RCIE; on arrete la reception usart 



	return			; fin d'interruption
					; peut tre remplac par 
					; retlw pour retour code d'erreur

;*****************************************************************************
;                     INTERRUPTION TRANSMISSION USART                        *
;*****************************************************************************
inttx
	return				; fin d'interruption
					; peut tre remplac par 
					; retlw pour retour code d'erreur

;*****************************************************************************
;                       INTERRUPTION CCP1                                    *
;*****************************************************************************
intccp1
	return				; fin d'interruption
					; peut tre remplac par 
					; retlw pour retour code d'erreur
;****************************************************************************
;                      INTERUPTION COMPARATEUR                              *
;****************************************************************************
intcmp
	return				; fin d'interruption
					; peut tre remplac par 
					; retlw pour retour code d'erreur
;*****************************************************************************
;                     INTERRUPTION TIMER 2                                   *
;*****************************************************************************
inttmr2
	return				; fin d'interruption
					; peut tre remplac par 
					; retlw pour retour code d'erreur

;*****************************************************************************
;                     INTERRUPTION TIMER 1                                   *
;*****************************************************************************
inttmr1
	return				; fin d'interruption
					; peut tre remplac par 
					; retlw pour retour code d'erreur

;*****************************************************************************
;                     INTERRUPTION EEPROM                                    *
;*****************************************************************************
inteprom
	return				; fin d'interruption
					; peut tre remplac par 
					; retlw pour retour code d'erreur

;*****************************************************************************
;                     INTERRUPTION CONVERTISSEUR A/D                         *
;*****************************************************************************
intad
	return				; fin d'interruption
					; peut tre remplac par 
					; retlw pour retour code d'erreur



; ////////////////////////////////////////////////////////////////////////////

;                           P R O G R A M M E

; ////////////////////////////////////////////////////////////////////////////

;*****************************************************************************
;                          INITIALISATIONS                                   *
;*****************************************************************************
init

			; initialisation PORTS (banque 0 et 1)
			; ------------------------------------
	BANK0				; slectionner banque0
	clrf	PORTA			; Sorties PORTA  0
	clrf	PORTB			; sorties PORTB  0
	BANK1				; passer en banque1
	movlw	DIRPORTA		; Direction PORTA
	movwf	TRISA			; criture dans registre direction
	movlw	DIRPORTB		; Direction PORTB
	movwf	TRISB			; criture dans registre direction

			; Registre de l'oscillateur
			; -------------------------
	movlw	OSCCONVAL		; charger le masque
	movwf	OSCCON			; initialiser registre

			; Registre d'options (banque 1)
			; -----------------------------
	movlw	OPTIONVAL		; charger masque
	movwf	OPTION_REG		; initialiser registre option

			; registres interruptions (banque 1)
			; ----------------------------------
	movlw	INTCONVAL		; charger valeur registre interruption
	movwf	INTCON			; initialiser interruptions
	movlw	PIE1VAL			; Initialiser registre 
	movwf	PIE1			; interruptions priphriques 1
	movlw	PIE2VAL			; Initialiser registre 
	movwf	PIE2			; interruptions priphriques 2
	movlw	CVRCONVAL		; charger masque
	movwf	CVRCON			; initialiser le registre tension de reference
	movlw	CMCONVAL		; charger masque
	movwf	CMCON			; initialiser le registre du comparateur
	movlw	ANSELVAL		; charger masque
	movwf	ANSEL			; initialiser le registre du convertisseur


			; Effacer RAM banque 0
			; ---------------------
	BANK0				    ; slectionner banque 0
    movlw	0x70			; initialisation pointeur
	movwf	FSR		 	    ; d'adressage indirect
init1
	clrf	INDF			; effacer ram
	incf	FSR,f			; pointer sur suivant
	btfss	FSR,3			; tester si fin zone atteinte (>7F)
	goto	init1			; non, boucler
    movlw   B'00110011'
    movwf   SPBRG           ; // Quartz 8Mhz , BRGH=1 donc SPBRG = 51;
    movlw   B'00000100'     ; // Pas de 9me bit. Emission dsactive. Mode Asynchrone. BRGH=1. TRMT=0. TX9D=0.
    movwf   TXSTA
    movlw   B'10000000'     ;usart en service pas de pariter 8bits
    movwf   RCSTA
			
            ; autoriser interruptions (banque 0)
			; ----------------------------------
	clrf	PIR1			; effacer flags 1
	clrf	PIR2			; effacer flags 2
	
    bsf	    INTCON,GIE		;  interruptions ok
	goto	start			; programme principal



;*****************************************************************************
;                      routine appelle de la tempo DURER 262 ms                                   *
;*****************************************************************************
tempo
    
    movlw   2 
    movwf   cmpt3
boucle3
    clrf    cmpt2
    
boucle2
	clrf	cmpt1				; effacer compteur1
boucle1
	nop							; perdre 1 cycle donc 256 cycles
	decfsz	cmpt1,f				; dcrmenter compteur1 256 cycles 
	goto	boucle1				; si pas 0, boucler	goto=2cycles donc 512 cycles 
	decfsz	cmpt2,f 			; si 0, dcrmenter compteur 2
	goto	boucle2				; si cmpt2 pas 0, recommencer boucle1 	goto=2cycles donc 512 cycles  
    decfsZ  cmpt3,f
    goto    boucle3             ;goto=2cycles donc 512 cycles 
	return	

;*****************************************************************************
;                      PROGRAMME PRINCIPAL                                   *
;*****************************************************************************

start
   BANK0
    movlw   B'10000001' ;mais aux +5VDC le portB 7 et 0 pour activer deux transistor 
	movwf  PORTB 
    movlw  B'01000001'
    movwf  PORTA; teste le debut du programme avec deux diodes allumes
    movlw  B'01000001'; valeur en binaire de la lettre a 
    movwf  valeur_comparer
    movf   valeur_comparer,w; on m'est le contenu de la variable valeur_comparer dans w puis comme adresse n
    movwf  n;l'adresse de n deviens la valeur que contient la variable valeur_comparer 
    movlw  bufin  ;charger l'adresse dans w
    movwf  pointer;l'adresse de bufin est placer dans la variable pointer
    bsf    RCSTA,CREN;on autorise la reception continu
    BANK1
    bsf    PIE1,RCIE;autorise reception usart
    btfss  PIE1,RCIE;teste de si y a reception RCIE=1 on saut 
    goto   start
    movlw  B'01000001'
    movwf  PORTA;teste si y a reception
    movf   bufin,w;le contenu de bufin est placer dans w
    xorlw  n;comparer avec la fonction ou exclusif
    btfsc  STATUS,Z ; on teste le Z de status si=1 start1 
    goto   start1
    goto   start

start1   
    movlw   B'10000001' ;mais aux +5VDC le portB 7 et 0 pour activer deux transistor 
	movwf  PORTB 
    movlw   B'10000001' ;allume les diodes sur le PORTA 7 et 0
    movwf  PORTA 
    call   tempo        ; appelle la tempo 0,5seconde
    movlw   B'01000010' ;eteints les diodes
    movwf  PORTA  
    call   tempo
    goto   start1 

end
